package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.bizobj.MviSyncCommErrAssembler;
import gov.va.med.mhv.usermgmt.bizobj.MviSyncCommErrBO;
import gov.va.med.mhv.usermgmt.bizobj.PatientAssembler;
import gov.va.med.mhv.usermgmt.bizobj.PatientBO;
import gov.va.med.mhv.usermgmt.service.MviSyncCommErrServiceResponse;
import gov.va.med.mhv.usermgmt.service.PatientServiceResponse;

import java.lang.Long;
import java.util.Collection;
import java.util.List;

import gov.va.med.mhv.usermgmt.service.MviSyncCommErrService;
import gov.va.med.mhv.usermgmt.transfer.MviSyncCommErr;
import gov.va.med.mhv.usermgmt.transfer.Patient;

/**
 * Service implementation class for the MviSyncCommErr service
 * @see gov.va.med.mhv.usermgmt.service.MviSyncCommErrService
 */
public class MviSyncCommErrServiceImpl implements MviSyncCommErrService {

	/**
	 * Execute the GetRequiredMviSyncByProfileId service
	 * @see gov.va.med.mhv.usermgmt.service.MviSyncCommErrService#GetRequiredMviSyncByProfileId()
	 */
	public MviSyncCommErrServiceResponse getRequiredMviSyncByProfileId(Long userProfileId) {
		MviSyncCommErrServiceResponse response = new MviSyncCommErrServiceResponse();
        Precondition.assertNotBlank("userProfileId", userProfileId.toString());
       
        List mviSyncCommErrBOs = MviSyncCommErrBO.getRequiredMviSyncByProfileId(userProfileId);
        Collection mviSyncCommErrs = MviSyncCommErrAssembler.getMviSyncCommErrCollection(mviSyncCommErrBOs);
        if (mviSyncCommErrs.size() > 0) {
        	response.setMviSyncCommErr((MviSyncCommErr)mviSyncCommErrs.iterator().next()); 
        }
		// Service business logic here
		
		return response;
	}

}